/*  Gibt die Kapazitäten und die Belastung der Kapazitäten einer gegebenen Ressource wochenweise zuürck. Die zurückgegebene
    Tabelle wird in der Anzeige der Auslastungen in der Plantafel verwendet.
*/
SELECT tsystem.function__drop_by_regex( 'resource_timeline__kapa_belast__get', 'scheduling', _commit => true );
CREATE OR REPLACE FUNCTION scheduling.resource_timeline__kapa_belast__get(
      _resource_id      integer
    , _timeframe_start  timestamp DEFAULT current_date
    , _timeframe_end    timestamp DEFAULT current_date + ( 31 * 7 * interval '1 day' )
  ) RETURNS TABLE (
      resource_id integer,
      wb_ks       varchar,
      wb_week     varchar,
      kapa        numeric(8,2),
      belast      numeric(8,2)
  ) AS $$

      SELECT  ti_resource_id,
            ksb.ksb_ks_shorthand AS wb_ks
          , termweek( ti_date_start ) AS wb_week,
            tplanterm.wkst_ksview_kskapa(
                ks    => ksb.ksb_ks_shorthand
              , oks   => ksb.ksb_ks_abt
              , week  => termweek( ti_date_start )::varchar
            ) AS kapa
          , sum(
                scheduling.resource_timeline__ab2__get_scheduled_time(
                    _ab2_id           => ti_a2_id
                  , _ti_types         => ARRAY[ 'task', 'task.buffer', 'task.blocktime' ]::scheduling.resource_timeline_blocktype[]
                  , _timeframe_start  => ti_date_start
                  , _timeframe_end    => ti_date_end
                  , _resource_id      => ti_resource_id
                )
            ) / 3600 AS belast -- scheduled Varinate 1
      --     , sum(
      --           scheduling.resource_timeline__ksv_shorthand__get_scheduled_time(
      --               _ksv_shorthand    => ksb.ksb_ks_shorthand
      --             , _timeframe_start  => ti_date_start
      --             , _timeframe_end    => ti_date_end
      --             , _ti_types         => ARRAY[ 'task', 'task.buffer', 'task.blocktime' ]::scheduling.resource_timeline_blocktype[]
      --           )
      --       ) / 3600 AS belast -- scheduled Varinate 2
      --     , sum(
      --           scheduling.resource_timeline__required_worktime__get(
      --               _tr_record => ti
      -- --            , _ab2__worktime_done__get => ab2__worktime_done__get
      -- --            , _ab2__required_worktime__get => ab2__required_worktime__get
      --           )
      --       ) / 3600 AS belast -- required
      FROM scheduling.resource_timeline AS ti
      CROSS JOIN LATERAL scheduling.resource__translate__resource_id__to__ksvba__shorthand( _resource_id => ti_resource_id ) AS ksb
      WHERE     ti_resource_id = _resource_id
            AND termweek( ti_date_start ) >= termweek( _timeframe_start )
            AND termweek( ti_date_end )   <  termweek( _timeframe_end )
      GROUP BY  termweek( ti_date_start )
              , ti_resource_id
              , ksb.ksb_ks_shorthand
              , ksb.ksb_ks_abt
      ORDER BY termweek( ti_date_start )

  $$ LANGUAGE sql;

CREATE OR REPLACE FUNCTION scheduling.resource_timeline__kapa_belast__get(
      _shorthand varchar
    , _timeframe_start  timestamp DEFAULT current_date
    , _timeframe_end    timestamp DEFAULT current_date + ( 31 * 7 * interval '1 day' )
  ) RETURNS TABLE (
      resource_id integer,
      wb_ks       varchar,
      wb_week     varchar,
      kapa        numeric(8,2),
      belast      numeric(8,2)
  ) AS $$

      SELECT *
      FROM  scheduling.resource_timeline__kapa_belast__get(
                _resource_id      => scheduling.resource__translate__ksvba__shorthand__to__resource_id( _shorthand => _shorthand )
              , _timeframe_start  => _timeframe_start
              , _timeframe_end    => _timeframe_end
            )

  $$ LANGUAGE sql;